# numeros : dict
class Grupo:
    # __init__ : None -> Grupo
    # entrega un Grupo de numeros vacios
    def __init__(self):
        self.numeros = {}
        
    # agregar : num -> None
    # agrega un numero al grupo
    def agregar(self,x):
        if x in self.numeros:
            self.numeros[x]+=1
        else:
            self.numeros[x]=1

    # sacarMayor : None -> num
    # extrae y retorna el mayor de los numeros del grupo
    def sacarMayor(self):
        llaves = self.numeros.keys()
        llaves.sort(reverse=True)
        for llave in llaves:
            if self.numeros[llave] > 0:
                self.numeros[llave]-=1
                return llave
        #Si no hay llaves, o todos estan en cero elementos
        #el grupo esta vacio.
        #Notar que nunca borramos elementos, si no que dejamos
        #elementos en cero
        return None
#test
G = Grupo()
G.agregar(10)
G.agregar(20)
G.agregar(15)

assert G.sacarMayor() == 20
assert G.sacarMayor() == 15
assert G.sacarMayor() == 10
assert G.sacarMayor() == None
